;;  Programm:      ACM-TRANSPARENZSETZEN.LSP
;;  Befehlsaufruf: ACM-TRANSPARENZSETZEN
;;  Funktion:      Aktuelle Transparenz per Quellobjektwahl oder Auswahlliste setzen.
;;  Autor:         Gerhard Rampf
;;                 Kundenspezifische Anpassungen fr AutoCAD und ZWCAD
;;                 Liebigstr. 3 A
;;                 86399 Bobingen
;;                 E-Mail: rampf@geracad.de
;;  Datum:         06.01.2025
;;  Plattform:     Alle AutoCAD-Versionen ab Version 2011
(defun c:acm-transparenzsetzen ( / trs39 trs40 trs11 trs41 tsr01 tsr02 tsr03 tsr04 tsr05 tsr06 tsr07 tsr08 tsr09 tsr10 tsr11)
    (defun tsr01 ( / trs05 trs06)
      (setq trs05 (strcase (getvar "PRODUCT")))
        (if
          (and
            (= trs05 "AUTOCAD")
            (getvar "TRANSPARENCYDISPLAY")
          )
            (setq trs06 T)
            (setq trs06 nil)
        )
        (if (not trs06)
          (alert "\042acm-transparenzsetzen\042 kann nur unter AutoCAD ab Version 2011 verwendet werden.")
        )
      trs06
    )
    (defun tsr02 (trs01 / trs07 trs08)
        (if
          (and
            (getvar "CETRANSPARENCY")
            (tblsearch "LAYER" trs01)
            (= (type trs01) 'STR)
          )
            (progn
              (if (not (setq trs07 (cdr (assoc 1071 (cdr (car (cdr (assoc -3 (entget (tblobjname "LAYER" trs01) '("AcCmTransparency"))))))))))
                (setq trs07 0)
                (progn
                  (if (setq trs08 (vl-position trs07 (list 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90 33554687 33554684 33554681 33554679 33554676 33554674 33554671 33554669 33554666 33554664 33554661 33554658 33554656 33554653 33554651 33554648 33554646 33554643 33554641 33554638 33554636 33554633 33554630 33554628 33554625 33554623 33554620 33554618 33554615 33554613 33554610 33554607 33554605 33554602 33554600 33554597 33554595 33554592 33554590 33554587 33554585 33554582 33554579 33554577 33554574 33554572 33554569 33554567 33554564 33554562 33554559 33554556 33554554 33554551 33554549 33554546 33554544 33554541 33554539 33554536 33554534 33554531 33554528 33554526 33554523 33554521 33554518 33554516 33554513 33554511 33554508 33554505 33554503 33554500 33554498 33554495 33554493 33554490 33554488 33554485 33554483 33554480 33554477 33554475 33554472 33554470 33554467 33554465 33554462 33554460 33554457)))
                    (setq trs07 (nth trs08 (list 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90)))
                    (setq trs07 (fix (- 100 (/ (lsh (lsh trs07 24) -24) 2.55))))
                  )
                )
              )
            )
        )
        (if
          (or
            (not trs07)
            (< trs07 0)
            (> trs07 90)
          )
            (setq trs07 0)
        )
      trs07
    )
    (defun tsr03 (trs02 / trs09 trs10)
        (if (= (type trs02) 'ENAME)
          (setq trs02 (vlax-ename->vla-object trs02))
        )
      (setq trs09 (vlax-get trs02 'EntityTransparency))
        (if (vl-string-search "LAYER" (strcase trs09))
          (setq trs10 -1)
        )
        (if (vl-string-search "BLOCK" (strcase trs09))
          (setq trs10 -2)
        )
        (if (not trs10)
          (setq trs10 (atoi trs09))
        )
      trs10
    )
    (defun tsr04 (trs03 / )
      (if trs11 (setq *error* trs11))
      (if trs39 (setvar "CMDECHO" trs39))
      (if trs32 (setvar "PICKBOX" trs32))
      (setq trs11 nil trs39 nil trs32 nil)
      (vla-EndUndoMark (vla-get-ActiveDocument (vlax-get-acad-object)))
      (princ)
    )
    (defun tsr05 (trs04 / trs12 trs13 trs14 trs15)
      (setq trs12 (list -1 -2 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90))
      (setq trs13 (list "_bylayer" "_byblock" "0" "1" "2" "3" "4" "5" "6" "7" "8" "9" "10" "11" "12" "13" "14" "15" "16" "17" "18" "19" "20" "21" "22" "23" "24" "25" "26" "27" "28" "29" "30" "31" "32" "33" "34" "35" "36" "37" "38" "39" "40" "41" "42" "43" "44" "45" "46" "47" "48" "49" "50" "51" "52" "53" "54" "55" "56" "57" "58" "59" "60" "61" "62" "63" "64" "65" "66" "67" "68" "69" "70" "71" "72" "73" "74" "75" "76" "77" "78" "79" "80" "81" "82" "83" "84" "85" "86" "87" "88" "89" "90"))
      (setq trs14 (list "VonLayer" "VonBlock" "0" "1" "2" "3" "4" "5" "6" "7" "8" "9" "10" "11" "12" "13" "14" "15" "16" "17" "18" "19" "20" "21" "22" "23" "24" "25" "26" "27" "28" "29" "30" "31" "32" "33" "34" "35" "36" "37" "38" "39" "40" "41" "42" "43" "44" "45" "46" "47" "48" "49" "50" "51" "52" "53" "54" "55" "56" "57" "58" "59" "60" "61" "62" "63" "64" "65" "66" "67" "68" "69" "70" "71" "72" "73" "74" "75" "76" "77" "78" "79" "80" "81" "82" "83" "84" "85" "86" "87" "88" "89" "90"))
      (setq trs15 (nth (vl-position trs04 trs12) trs13))
      (setvar "CETRANSPARENCY" trs04)
      (prompt (strcat "\nNeue aktuelle Transparenz: " (nth (vl-position trs04 trs12) trs14) " "))
    )
    (defun tsr06 ( / trs18 trs16 trs17)
      (if
        (and
          (setq trs16 (vl-filename-mktemp "acm.dcl"))
          (setq trs17 (open trs16 "w"))
        )
          (progn
            (setq trs18
              (list
                "acm_ccs"
                ":dialog{label=\042Einstellungen\042;"
                ":spacer{height=0.2;}"
                ":popup_list{key=\042pl_01\042;label=\042&Pickbox-Gre:\042;edit_width=8;}"
                ":spacer{height=0.3;}"
                ":toggle{key=\042tg_01\042;label=\042&Blockelemente whlbar\042;}"
                ":toggle{key=\042tg_02\042;label=\042&VonLayer ersetzen\042;}"
                ":spacer{height=0.3;}"
                ":row{"
                ":spacer{width=0;}"
                ":column{width=0;fixed_width=true;"
                ":button{key=\042b_01\042;label=\042OK\042;is_default=true;}"
                ":button{key=\042b_02\042;label=\042Abbrechen\042;is_cancel=true;}}"
                ":spacer{width=0;}}}"
              )
            )
              (while trs18
                (write-line (car trs18) trs17)
                (setq trs18 (cdr trs18))
              )
            (setq trs17 (close trs17))
            trs16
          )
          nil
      )
    )
    (defun tsr07 ( / trs19 trs20 trs21 trs24)
        (if (setq trs19 (tsr06))
          (progn
            (setq trs20 (load_dialog trs19))
              (if (not (new_dialog "acm_ccs" trs20))
                (exit)
              )
            (vl-catch-all-apply 'vl-file-delete (list trs19))
            (start_list "pl_01")
            (mapcar 'add_list (list (strcat "Akt. (" (itoa (getvar "PICKBOX")) ")") "1" "2" "3" "4" "5" "6" "7" "8" "9" "10" "11" "12" "13" "14" "15" "16" "17" "18" "19" "20"))
            (end_list)
            (set_tile "tg_01" (itoa bis72_l85-uskebdc))
            (set_tile "tg_02" (itoa bis72_l85-uskebdd))
              (if (= bis72_l85-uskebda 0)
                (set_tile "pl_01" "0")
                (set_tile "pl_01" (itoa bis72_l85-uskebdb))
              )
              (action_tile "b_01" "(setq trs21 (atoi (get_tile \"pl_01\")))
                  (if (= trs21 0)
                    (progn
                      (setq bis72_l85-uskebda 0)
                      (setq bis72_l85-uskebdb (getvar \"PICKBOX\"))
                    )
                    (progn
                      (setq bis72_l85-uskebda 1)
                      (setq bis72_l85-uskebdb trs21)
                    )
                  )
                (setq trs24 (list (setq bis72_l85-uskebdc (atoi (get_tile \"tg_01\"))) (setq bis72_l85-uskebdd (atoi (get_tile \"tg_02\"))) bis72_l85-uskebda bis72_l85-uskebdb))
                (done_dialog)
                (tsr08)"
              )
            (action_tile "b_02" "(setq trs24 nil) (done_dialog)")
            (start_dialog)
            (unload_dialog trs20)
          )
        )
      trs24
    )
    (defun tsr08 ( / )
      (if (not (vl-position bis72_l85-uskebda (list 0 1)))
        (setq bis72_l85-uskebda 0)
      )
      (if (not (vl-position bis72_l85-uskebdb (list 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20)))
        (progn
          (setq bis72_l85-uskebda 0)
          (setq bis72_l85-uskebdb (getvar "PICKBOX"))
        )
      )
      (if (not (vl-position bis72_l85-uskebdc (list 0 1)))
        (setq bis72_l85-uskebdc 0)
      )
      (if (not (vl-position bis72_l85-uskebdd (list 0 1)))
        (setq bis72_l85-uskebdd 0)
      )
      (prompt
        (strcat
          "\nAktuelle Einstellungen fr Wahl der Transparenz: Pickbox-Gre = "
            (if (= bis72_l85-uskebda 0)
              (strcat "Aktuelle (" (itoa (getvar "PICKBOX")) ")")
              (itoa bis72_l85-uskebdb)
            )
          ", Blockelemente whlbar = "
          (nth bis72_l85-uskebdc (list "Nein" "Ja"))
          ", VonLayer ersetzen = "
          (nth bis72_l85-uskebdd (list "Nein" "Ja"))
        )
      )
    )
    (defun tsr09 ( / trs12 trs13 trs28 trs29 trs30 trs31 trs32 trs33 trs34 trs35 trs36 trs37)
      (setq trs12 (list -1 -2 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90))
        (if (not (vl-position bis72_l85-uskebde trs12))
          (setq bis72_l85-uskebde -1)
        )
      (setq trs13 (list "VonLayer" "VonBlock" "0" "1" "2" "3" "4" "5" "6" "7" "8" "9" "10" "11" "12" "13" "14" "15" "16" "17" "18" "19" "20" "21" "22" "23" "24" "25" "26" "27" "28" "29" "30" "31" "32" "33" "34" "35" "36" "37" "38" "39" "40" "41" "42" "43" "44" "45" "46" "47" "48" "49" "50" "51" "52" "53" "54" "55" "56" "57" "58" "59" "60" "61" "62" "63" "64" "65" "66" "67" "68" "69" "70" "71" "72" "73" "74" "75" "76" "77" "78" "79" "80" "81" "82" "83" "84" "85" "86" "87" "88" "89" "90"))
        (if (/= bis72_l85-uskebde -1)
          (progn
            (setq trs28 "Vonlayer Auswahlliste Einstellungen")
            (setq trs29 (strcat "\nAktuell zu setzende Transparenz durch Objekt whlen oder [Vonlayer/Auswahlliste/Einstellungen] <" (nth (vl-position bis72_l85-uskebde trs12) trs13) ">: "))
          )
          (progn
            (setq trs28 "Auswahlliste Einstellungen")
            (setq trs29 "\nAktuell zu setzende Transparenz durch Objekt whlen oder [Auswahlliste/Einstellungen] <VonLayer>: ")
          )
        )
      (setq trs30 (getvar "ERRNO"))
      (setvar "ERRNO" 7)
        (while (= (getvar "ERRNO") 7)
          (setvar "ERRNO" 0)
            (if (= bis72_l85-uskebdc 0)
              (setq trs31 entsel)
              (setq trs31 nentsel)
            )
          (setq trs32 (getvar "PICKBOX"))
          (setvar "PICKBOX" bis72_l85-uskebdb)
          (initget trs28)
          (setq trs33 (trs31 trs29))
          (setvar "PICKBOX" trs32)
            (if (not trs33)
              (setq trs34 bis72_l85-uskebde)
              (progn
                (if (= (type trs33) 'STR)
                  (progn
                    (if (= trs33 "Vonlayer")
                      (setq trs34 -1)
                    )
                    (if (= trs33 "Auswahlliste")
                      (progn
                        (if (not (setq trs34 (car (tsr11))))
                          (setvar "ERRNO" 7)
                        )
                      )
                    )
                    (if (= trs33 "Einstellungen")
                      (progn
                        (tsr07)
                        (setvar "ERRNO" 7)
                        (setq trs35 T)
                      )
                    )
                  )
                  (progn
                    (setq trs36 (car trs33))
                    (setq trs37 (entget trs36))
                    (setq trs34 (tsr03 trs36))
                      (if (= trs34 -1)
                        (progn
                          (if (= bis72_l85-uskebdd 0)
                            (setq trs34 -1)
                            (setq trs34 (tsr02 (cdr (assoc 8 trs37))))
                          )
                        )
                      )
                  )
                )
              )
            )
            (if
              (and
                (= (getvar "ERRNO") 7)
                (not trs35)
              )
                (prompt "0 gefunden")
            )
          (setq trs35 nil)
        )
        (if trs30
          (setvar "ERRNO" trs30)
        )
      (if trs34
        (setq bis72_l85-uskebde trs34)
        nil
      )
    )
    (defun tsr10 ( / trs18 trs16 trs17)
      (if
        (and
          (setq trs16 (vl-filename-mktemp "acm.dcl"))
          (setq trs17 (open trs16 "w"))
        )
          (progn
            (setq trs18
              (list
                "acm_ctr"
                ":dialog{label=\042Transparenz whlen\042;initial_focus=\042lb_01\042;"
                ":spacer{height=0.2;}"
                ":list_box{key=\042lb_01\042;height=12;allow_accept=true;}"
                ":spacer{height=0.3;}"
                ":row{"
                ":spacer{width=1;}"
                ":column{width=0;fixed_width=true;"
                ":button{key=\042b_01\042;label=\042OK\042;is_default=true;}"
                ":button{key=\042b_02\042;label=\042Abbrechen\042;is_cancel=true;}}"
                ":spacer{width=1;}}}"
              )
            )
              (while trs18
                (write-line (car trs18) trs17)
                (setq trs18 (cdr trs18))
              )
            (setq trs17 (close trs17))
            trs16
          )
          nil
      )
    )
    (defun tsr11 ( / trs19 trs20 trs12 trs13 trs38 trs24)
        (if (setq trs19 (tsr10))
          (progn
            (setq trs20 (load_dialog trs19))
              (if (not (new_dialog "acm_ctr" trs20))
                (exit)
              )
            (vl-catch-all-apply 'vl-file-delete (list trs19))
            (setq trs12 (list -1 -2 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90))
              (if (not (vl-position bis72_l85-uskebde trs12))
                (setq bis72_l85-uskebde -1)
              )
            (setq trs13 (list "VonLayer" "VonBlock" "0" "1" "2" "3" "4" "5" "6" "7" "8" "9" "10" "11" "12" "13" "14" "15" "16" "17" "18" "19" "20" "21" "22" "23" "24" "25" "26" "27" "28" "29" "30" "31" "32" "33" "34" "35" "36" "37" "38" "39" "40" "41" "42" "43" "44" "45" "46" "47" "48" "49" "50" "51" "52" "53" "54" "55" "56" "57" "58" "59" "60" "61" "62" "63" "64" "65" "66" "67" "68" "69" "70" "71" "72" "73" "74" "75" "76" "77" "78" "79" "80" "81" "82" "83" "84" "85" "86" "87" "88" "89" "90"))
              (if (not (setq trs38 (vl-position bis72_l85-uskebde trs12)))
                (setq trs38 0)
              )
            (start_list "lb_01")
            (mapcar 'add_list trs13)
            (end_list)
            (set_tile "lb_01" (itoa trs38))
            (action_tile "b_01" "(setq bis72_l85-uskebde (nth (atoi (get_tile \"lb_01\")) trs12)) (setq trs24 (list bis72_l85-uskebde 0)) (done_dialog)")
            (action_tile "b_02" "(setq trs24 nil) (done_dialog)")
            (start_dialog)
            (unload_dialog trs20)
          )
        )
      trs24
    )
  (if (tsr01)
    (progn
      (vl-load-com)
      (setq trs39 (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (setq trs40 (vla-get-ActiveDocument (vlax-get-acad-object)))
      (setq trs11 *error*)
      (setq *error* tsr04)
      (vla-EndUndoMark trs40)
      (vla-StartUndoMark trs40)
      (tsr08)
        (if (setq trs41 (tsr09))
          (tsr05 trs41)
        )
        (if trs11
          (setq *error* trs11)
          (setq *error* nil)
        )
      (setvar "CMDECHO" trs39)
      (vla-EndUndoMark trs40)
    )
  )
  (princ)
)
(terpri)
(princ (strcat "\nAutoLISP-Tool ACM-TRANSPARENZSETZEN (Copyright  " (substr (rtos (getvar "CDATE")) 1 4) " Gerhard Rampf) geladen. "))
(princ "\nRufen Sie den Befehl mit ACM-TRANSPARENZSETZEN auf.")
